package org.apache.taglibs.extended.script.samples;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JythonController extends HttpServlet {
	private static final long serialVersionUID = 1L;
	

    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

    	// get personService from session, create new one if one does not yet exist
    	Object personServiceObj = request.getSession().getAttribute("personService");
    	PersonService personService = null;
    	if (personServiceObj == null) {
    		personService = new PersonService();
    		request.getSession().setAttribute("personService", personService);
    	}
    	else {
    		personService = (PersonService) personServiceObj;
    	}
    	
    	System.out.println(personService);
    	
    	String target = request.getParameter("target");
    	
    	if (target == null || target.equals("list")) {
    		request.getRequestDispatcher("/jython/list.jsp").forward(request, response);
    	}
    	else if (target.equals("new")) {
    		request.getRequestDispatcher("/jython/new.jsp").forward(request, response);
    	}
    	else if (target.equals("edit")) {
    		request.getRequestDispatcher("/jython/edit.jsp").forward(request, response);
    	}
    	else if (target.equals("delete")) {
    		request.getRequestDispatcher("/jython/delete_do.jsp").forward(request, response);
    	}
    	
    }

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
    	
    	String target = request.getParameter("target");
    	
    	if (target == null) {
    		request.getRequestDispatcher("/jython/list.jsp").forward(request, response);
    	}
    	else if (target.equals("new")) {
    		request.getRequestDispatcher("/jython/new_do.jsp").forward(request, response);
    	}      
    	else if (target.equals("edit")) {
    		request.getRequestDispatcher("/jython/edit_do.jsp").forward(request, response);
    	}
    }
}
